//---------------------------------------------------------------
// Fichero:  construccion.asy
// Objetivo: Representar cómo se construye el sombrero
// Fecha:    M.28.3.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Función que dibuja lados y apotemas de un hexágono
void DibujaHexagono(path H)
    {
    for ( int i=0 ; i<3 ; ++i )
        {
        // Las apotemas
        pen Apotema=0.75bp+mediumblue;
        draw(((point(H,i)+point(H,i+1))/2)--((point(H,i+3)+point(H,i+4))/2),
             Apotema);
        // Los lados
        pen Lado=1.5bp+mediumred;
        draw(point(H,i)--point(H,i+1), Lado);
        draw(point(H,i+3)--point(H,i+4), Lado);
        }
    }

// El hexágono de la izquierda
path H1=polygon(6);

// El hexágono de la derecha, arriba
path H2=shift(1.5,1*sqrt(3)/2)*H1;

// El hexágono de la derecha, abajo
path H3=shift(1.5,-1*sqrt(3)/2)*H1;

// Dibujamos los hexágonos
DibujaHexagono(H1);
DibujaHexagono(H2);
DibujaHexagono(H3);

// Los trece vértices del sombrero
pair V[];
V[0] = (point(H1,2)+point(H1,3))/2;
V[1] = (point(H1,0)+point(H1,3))/2;
V[2] = (point(H1,4)+point(H1,5))/2;
V[3] = point(H1,5);
V[4] = point(H1,0);
V[5] = (point(H1,0)+point(H1,1))/2;
V[6] = (point(H3,0)+point(H3,3))/2;
V[7] = (point(H3,1)+point(H3,2))/2;
V[8] = point(H3,2);
V[9] = (point(H3,2)+point(H3,3))/2;
V[10] = (point(H2,0)+point(H2,3))/2;
V[11] = (point(H2,3)+point(H2,4))/2;
V[12] = point(H1,2);

// Construimos y dibujamos el sombrero
guide Sombrero;
for ( int i=0 ; i<13 ; ++i )
    { Sombrero = Sombrero -- V [i]; }
Sombrero = Sombrero -- cycle;
draw(Sombrero, 2.5bp+black);
