//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Representar un polígono con su notación
// Fecha:    V.11.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,4.2cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair V[]={(-1,0), (1,0), (1,1), (4,1), (5,0), (7,1.5),
          (5,3), (4,2), (1,2), (1,3), (-1,3)};
V.cyclic=true;

// Definición de las posiciones de las etiquetas de los vértices
pair PosV[]={SW, S, SE, SW, S, E, N, NW, NE, NE, N};

// Definición de las posiciones de las etiquetas de los lados
pair PosL[]={S, SE, S, SW, SE, NE, NW, N, NE, N, W};

// Los vértices
for (int i=0; i<V.length; ++i)
    { dot(Label("$\textup{V}"+"_{"+string(i+1)+"}$",fontsize(8pt)+deepgreen), V[i], PosV[i], 3bp+black); }

// Los lados
for (int i=0; i<V.length; ++i)
    { label(Label("$\textup{a}"+"_{"+string(i+1)+"}$",fontsize(8pt)+darkred), (V[i]+V[i+1])/2, PosL[i]); }

// Los ángulos
pen FormAng=fontsize(8pt)+blue;
pen FormArc=0.5bp+blue;
for (int i=0; i<V.length; ++i)
    { markangle(Label("$\alpha"+"_{"+string(i+1)+"}$",FormAng),
                radius=1.5mm, V[i+1], V[i], V[i-1], FormArc); }

// El polígono
guide Poligono;
for (int i=0; i<V.length; ++i)
    { Poligono = Poligono -- V[i]; }
  Poligono = Poligono -- cycle;
draw(Poligono);

label("P", (2.5,1.5));
