//---------------------------------------------------------------
// Fichero:  concavo2.asy
// Objetivo: Representar un polígono cóncavo
// Fecha:    D.13.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo EPS
settings.outformat="eps";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un color según sea el ángulo
pen Color(pair P1, pair V, pair P2)
    {
    pen Respuesta;

    real Ang = degrees(P2-V)-degrees(P1-V);
    bool Obtuso = Ang > 0 & Ang < 180 | Ang < -180;
    if ( Obtuso ) { Respuesta = heavygreen; }
    else         { Respuesta = heavyred; }

    return Respuesta;
    }

// Definición de los vértices
pair V[]={(0,0), (11,0.2), (9,1), (11,5), (0,5), (4,3)};
V.cyclic=true;

// Definición de puntos con segmentos interiores
pair I[]={(1,0.25), (8,1), (1.2,4.75), (9.5,4)};

// Definición de puntos con segmentos que desbordan
pair E[]={(10,0.35), (10.2,4.7), (2,1), (3,4)};

// Las líneas interiores
for (int i=0; i<I.length/2; ++i)
    { draw(I[2*i] -- I[2*i+1], heavygreen); }

// Las líneas que desbordan
for (int i=0; i<E.length/2; ++i)
    { draw(E[2*i] -- E[2*i+1], heavyred); }

// Los puntos
for (int i=0; i<I.length; ++i)
    { dot(I[i], 3bp+blue); }
for (int i=0; i<E.length; ++i)
    { dot(E[i], 3bp+blue); }

// Los ángulos
for (int i=0; i<V.length; ++i)
    {
    pen ColorMarca = Color(V[i+1], V[i], V[i-1]);
    markangle(radius=5bp, V[i+1], V[i], V[i-1], 10bp+ColorMarca);
    }

// El polígono
guide Poligono;
for (int i=0; i<V.length; ++i)
    { Poligono = Poligono -- V[i]; }
  Poligono = Poligono -- cycle;
draw(Poligono);
