//---------------------------------------------------------------
// Fichero:  enunciado.asy
// Objetivo: Enunciado
// Fecha:    M.15.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Los vértices
pair A=(0,0), B=(21,0), C=(21,3), D=(15,3), E1=(15,5), F=(0,5);

// El polígono
draw(A -- B -- C -- D -- E1 -- F -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, S, blue);
label(Dist(A,F), (A+F)/2, W, blue);
label(Dist(B,C), (B+C)/2, E, blue);
label(Dist(E1,F), (E1+F)/2, N, blue);
