//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Ángulos centrales de un polígono regular de 5 lados
// Fecha:    D.20.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El polígono
path Poligono=polygon(5);

// Los ángulos centrales
for ( int i=0 ; i<5 ; ++i )
    {
    pair V1=point(Poligono,i);
    pair V2=point(Poligono,i+1);
    markangle(Label("$72^\circ$",fontsize(10pt)+blue),
              radius=3mm, V1, (0,0), V2, 1bp+blue);
    draw(V1 -- (0,0) -- V2, 1bp+gray);
    }

// El polígono
draw(Poligono);

