//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Ejemplo 2
// Fecha:    X.23.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 8, Ymin = 0, Ymax = 3;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.5bp+gray));

// Grosor de las líneas
defaultpen(1);

// Marcamos en gris todos los puntos de coordenadas enteras
for ( int i=0 ; i<=Xmax ; ++i )
    {
    for ( int j=0 ; j<=Ymax ; ++j )
        { dot((i,j), 3bp+gray);}
    }

// Los vértices
pair V[]={(0,1), (2,2), (3,3), (4,1), (8,3), (6,1), (4,0), (2,0)};

// El polígono
guide Poligono;
for (int i=0; i<V.length; ++i)
    { Poligono = Poligono -- V[i]; }
  Poligono = Poligono -- cycle;
draw(Poligono);

// Los vértices
for ( int i=0 ; i<V.length ; ++i )
    { dot(V[i], 3bp+red); }

// Los puntos del perímetro
pair Perimetro[] = {(6,2), (7,2), (3,0) };
for ( int i=0 ; i<Perimetro.length ; ++i )
    { dot(Perimetro[i], 3bp+red); }

// Los puntos del interior
pair Interior[] = {(1,1), (2,1), (3,1), (5,1), (3,2) };
for ( int i=0 ; i<Interior.length ; ++i )
    { dot(Interior[i], 3bp+heavygreen); }
