//---------------------------------------------------------------
// Fichero:  solucion.asy
// Objetivo: Mostrar la solución
// Fecha:    D.11.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Dimensiones de los ejes
real Xmin = -12, Xmax = 12, Ymin = -6, Ymax = 6, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos
pair A=(-3,-2), B=(3,2), C=(-1,3), D=(1,-3), E1=(-7,-1);
pair F=(5,-4), G=(9,-5), H=(-6,-4), I=(-11,0), J=(6,4), K=(-5,4);
pair L=(-9,5), M=(7,1), N1=(11,0), O1=(0,0);

// Definición de los puntos para dibujar las rectas
pair R1=(-11.78,5.69), R2=(11.7,-0.17);
pair S1=(-11.72,0.18), S2=(11.7,-5.67);
pair T1=(-8.43,-5.62), T2=(8.64,5.76);

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Los puntos
dot(Label("A"), A, N, 5pt+black);
dot(Label("B"), B, N, 5pt+black);
dot(Label("C"), C, SW, 5pt+black);
dot(Label("D"), D, S, 5pt+black);
dot(Label("E"), E1, S, 5pt+black);
dot(Label("F"), F, NE, 5pt+black);
dot(Label("G"), G, NE, 5pt+black);
dot(Label("H"), H, SE, 5pt+black);
dot(Label("I"), I, NE, 5pt+black);
dot(Label("J"), J, NW, 5pt+black);
dot(Label("K"), K, SW, 5pt+black);
dot(Label("L"), L, SW, 5pt+black);
dot(Label("M"), M, N, 5pt+black);
dot(Label("N"), N1, NE, 5pt+black);
dot(Label("O"), O1, SE, 5pt+black);

// Las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T1 -- T2);

// Los nombres de las rectas
label("$r$", (-3,4));
label("$s$", (3,-3.1));
label("$t$", (1,1));
