//---------------------------------------------------------------
// Fichero:  enunciado.asy
// Objetivo: Mostrar el enunciado
// Fecha:    L.12.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(16cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los puntos para dibujar las rectas
pair R1=(1,13), R2=(21,11);
pair S1=(1,4), S2=(21,6);
pair T1=(6,15), T2=(3,2);
pair U1=(17,15), U2=(14,2);

// Definición de las rectas
path r = R1 -- R2;
path s = S1 -- S2;
path t = T1 -- T2;
path u = U1 -- U2;

// Los puntos de corte de las rectas
pair A = intersectionpoint(r,t);
pair B = intersectionpoint(r,u);
pair C = intersectionpoint(s,u);
pair D = intersectionpoint(s,t);

// Las rectas
draw(r); draw(s); draw(t); draw(u);

// Los nombres de las rectas
label("$r$", R1, NE);
label("$s$", S1, NE);
label("$t$", T1, SE);
label("$u$", U1, SE);

// Los puntos
dot(Label("A"), A, NW);
dot(Label("B"), B, NW);
dot(Label("C"), C, NW);
dot(Label("D"), D, NW);
