//---------------------------------------------------------------
// Fichero:  noperpendiculares.asy
// Objetivo: Representar dos rectas secantes no perpendiculares
// Fecha:    L.12.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos que definen las regiones
pair ArrIzq = (0.2,1.9), ArrDer = (3.8,1.9);
pair AbaIzq = (0.2,0.1), AbaDer = (3.8,0.1);
pair Centro = (2,1);

// Las regiones
fill(ArrIzq -- ArrDer -- Centro -- cycle, pink);
fill(AbaIzq -- AbaDer -- Centro -- cycle, pink);
fill(ArrIzq -- AbaIzq -- Centro -- cycle, palecyan);
fill(ArrDer -- AbaDer -- Centro -- cycle, palecyan);

// Las rectas
draw((0,2) -- (4,0));
draw((0,0) -- (4,2));

// El punto de corte
dot(Centro, 4bp+black);
