//---------------------------------------------------------------
// Fichero:  otrapropiedad.asy
// Objetivo: Representar otra propiedad de rectas perpendiculares
// Fecha:    L.12.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Marcamos los ángulos rectos
markrightangle((2,0.5), (1,0.5), (1,2), 2mm, gray);
markrightangle((4,0.5), (3,0.5), (3,2), 2mm, gray);

// Las rectas
draw((0,0.5) -- (4,0.5));
draw((1,0) -- (1,2));
draw((3,0) -- (3,2));

// Los nombres de las rectas
label("$r$", (4,0.5), E);
label("$s$", (1,2), SW);
label("$t$", (3,2), SW);
