//---------------------------------------------------------------
// Fichero:  propiedad2.asy
// Objetivo: Representar un caso de la propiedad de la recta perpendicular
// Fecha:    L.12.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Parte izquierda, el planteamiento
draw((0,0) -- (4,0));
dot(Label("P"), (1,0), NW);
label("$r$", (4,0), E);

// Parte derecha, el resultado
draw((6,0) -- (10,0));
draw((7,-0.5) -- (7,2));
dot(Label("P"), (7,0), NW);
label("$r$", (10,0), E);
label("$s$", (7,1.8), E);
markrightangle((7,2), (7,0), (8,0), 2mm, gray);

// En el centro, la flecha
label("$\Rightarrow$", (5,1));
