//---------------------------------------------------------------
// Fichero:  ejemplos.asy
// Objetivo: Representar ejemplos de puntos equidistantes
// Fecha:    X.14.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Los extremos del segmento
pair A=(1,0), B=(7,0);

// El punto P
pair P = (4,1);
draw(A -- P -- B, blue);
dot("P", P, NW, 5bp+black);

// El punto Q
pair Q = (4,-0.5);
draw(A -- Q -- B, blue);
dot("Q", Q, SW, 5bp+black);

// El punto R
pair R = (4,-1.5);
draw(A -- R -- B, blue);
dot("R", R, SW, 5bp+black);

// La recta base del segmento
draw((0,0) -- (8,0));

// Los extremos
dot("A", A, N, 5bp+black);
dot("B", B, N, 5bp+black);

// La mediatriz
draw((4,-2) -- (4,2));
label("$m$", (4,2), SE);
