//---------------------------------------------------------------
// Fichero:  proyeccion.asy
// Objetivo: Representar la proyección de un punto sobre una recta
// Fecha:    J.15.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(2);

// Extremos de la recta
pair R1=(-2,0), R2=(2,0);

// El punto
pair P=(0,1.5);

// La recta
draw(R1 -- R2);
label("$r$", R1, N);

// El segmento que marca la distancia
pair D=(0,0);
draw(D -- P, 2bp+heavygreen);
dot(D, 3bp+heavygray);

// El punto
dot("P", P, N, 6bp+black);

// La proyección
dot("Q", (0,0), NW, 6bp+black);

// Marcamos el ángulo recto
markrightangle((1,0), (0,0), (0,1), 4mm, gray);
