//---------------------------------------------------------------
// Fichero:  recta1.asy
// Objetivo: Representar un ejemplo de distancia de punto a recta
// Fecha:    J.15.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,4cm);

// Grosor de las líneas
defaultpen(2);

// Extremos de la recta
pair R1=(-1.5,0), R2=(2,0);

// El punto
pair P=(0,1);

// La recta
draw(R1 -- R2);

// El segmento que marca la distancia
pair D=(0,0);
draw(D -- P, 2bp+heavygreen);
dot(D, 3bp+heavygray);

// Otros segmentos
pair A=(-1,0);
draw(A -- P, 2bp+red);
dot(A, 3bp+heavygray);
pair B=(1.5,0);
draw(B -- P, 2bp+red);
dot(B, 3bp+heavygray);

// El punto
dot(P, 6bp+black);

// Marcamos el ángulo recto
markrightangle((1,0), (0,0), (0,1), 4mm, gray);
