//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Representar el ejemplo 2
// Fecha:    S.17.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.5cm);

// Grosor de las líneas
defaultpen(1);

// Extremos de la recta
pair R1=(0,-4), R2=(0,3);

// Los puntos
pair A1=(-4,2), B1=(-1,2), C1=(-1,-3), D1=(-4,-3);

// Los puntos simétricos
pair A2=(4,2), B2=(1,2), C2=(1,-3), D2=(4,-3);

// Las figuras
draw(A1 -- B1 -- C1 -- D1 -- cycle);
draw(A2 -- B2 -- C2 -- D2 -- cycle);

// Marcamos todos los puntos
dot("A", A1, NW, 4bp+black);
dot("B", B1, NE, 4bp+black);
dot("C", C1, SE, 4bp+black);
dot("D", D1, SW, 4bp+black);
dot("A'", A2, NE, 4bp+black);
dot("B'", B2, NW, 4bp+black);
dot("C'", C2, SW, 4bp+black);
dot("D'", D2, SE, 4bp+black);

// La recta
draw(R1 -- R2);
label("$r$", R2, N);
