//---------------------------------------------------------------
// Fichero:  circunferencia.asy
// Objetivo: Representar ejes de simetría de una circunferencia
// Fecha:    D.27.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Extremos de la recta principal
pair R1=(0,1.2), R2=(0,-1.2);

// Las rectas
path eje = R1 -- R2;
draw(eje, 2bp+blue);
draw(rotate(30)*eje, 2bp+blue);
draw(rotate(-60)*eje, 2bp+blue);

// La figura
draw(circle((0,0),1));

// El centro de la circuferencia
dot((0,0), 4bp+black);
