//---------------------------------------------------------------
// Fichero:  solucion1.asy
// Objetivo: Representar la solución 1
// Fecha:    X.5.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Sin() Cos()
import math;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(1,0), C=(Cos(60),Sin(60));

// Los puntos medios
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;
pair MBC=(B+C)/2;

// El triangulo
draw(A -- B -- C -- cycle);

// Las bisectrices
pair U1=A+0.1*(A-MBC);
pair U2=A-0.9*(A-MBC);
draw(U1 -- U2, 1bp+deepgreen);
pair V1=B+0.1*(B-MAC);
pair V2=B-0.9*(B-MAC);
draw(V1 -- V2, 1bp+deepgreen);
pair W1=C+0.1*(C-MAB);
pair W2=C-0.9*(C-MAB);
draw(W1 -- W2, 1bp+deepgreen);

// El incentro
pair I=intersectionpoint(U1 -- U2, V1 -- V2);
dot(I, 4bp+deepgreen);
