//---------------------------------------------------------------
// Fichero:  solucion2.asy
// Objetivo: Representar la solución 2
// Fecha:    D.23.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=rotate(10)*(2,1), C=rotate(10)*(-2,1);

// El triangulo
draw(A -- B -- C -- cycle);

// Función que devuelve un vector en la dirección bisectriz
pair Bisectriz(pair P1, pair V, pair P2)
    { return unit(P1-V) + unit(P2-V); }

// Las bisectrices
pair VR = Bisectriz(A,B,C);
pair R1 = B + 1.2*VR;
pair R2 = B - 0.1*VR;
draw(R1 -- R2, 1bp+deepgreen);
pair VS = Bisectriz(B,A,C);
pair S1 = A + 1.2*VS;
pair S2 = A - 0.1*VS;
draw(S1 -- S2, 1bp+deepgreen);
pair VT = Bisectriz(B,C,A);
pair T1 = C + 1.2*VT;
pair T2 = C - 0.1*VT;
draw(T1 -- T2, 1bp+deepgreen);

// El incentro
pair I=intersectionpoint(R1 -- R2, S1 -- S2);
dot(I, 4bp+deepgreen);
