//---------------------------------------------------------------
// Fichero:  enunciado01.asy
// Objetivo: Representar el enunciado 1
// Fecha:    V.30.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(5,1), C=(1,4);

// Los ángulos
markangle("$\alpha$", radius=5mm, C, B, A, 0.5bp+blue);
markangle("$64^\circ$", radius=5mm, B, A, C, 0.5bp+blue);
markangle("$48^\circ$", radius=5mm, A, C, B, 0.5bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);
