//---------------------------------------------------------------
// Fichero:  enunciado02.asy
// Objetivo: Representar el enunciado 2
// Fecha:    V.30.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(5,0), C=(1,3);

// Punto auxiliar
pair D=(6,0);

// Los ángulos
markangle("$\alpha$", radius=5mm, D, B, C, 0.5bp+blue);
markangle("$70^\circ$", radius=5mm, B, A, C, 0.5bp+blue);
markangle("$61^\circ$", radius=5mm, A, C, B, 0.5bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// La línea auxiliar
draw(D -- B);
