//---------------------------------------------------------------
// Fichero:  enunciado06.asy
// Objetivo: Representar el enunciado 6
// Fecha:    V.30.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle() markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,2), C=(-2,7);

// Los ángulos
markangle("$\alpha$", radius=8mm, C, B, A, 0.5bp+blue);
markangle("$39^\circ$", radius=8mm, A, C, B, 0.5bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// El ángulo recto
markrightangle(B, A, C, 4mm, gray);
