//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Representar el enunciado 1
// Fecha:    V.7.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,0), C=(3,4);

// Punto medio de la base
pair M=(A+B)/2;

// Los ángulos
markangle("$\alpha$", radius=5mm, M, C, B, 0.5bp+blue);
markangle("$53^\circ$", radius=5mm, M, A, C, 0.5bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// La altura
draw(M -- C);

// Las marcas
marker FormExt = StickIntervalMarker(i=1, n=3, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(A -- C, FormExt);
draw(B -- C, FormExt);

marker FormInt = StickIntervalMarker(i=1, n=2, angle=135, size=2.5mm,
                                    space=1mm, p=red);
draw(A -- M, FormInt);
draw(B -- M, FormInt);
