//---------------------------------------------------------------
// Fichero:  enunciado6.asy
// Objetivo: Representar el enunciado 6
// Fecha:    X.19.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.6cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(0,65), C=(72,0);

// El punto medio
pair M=(36,0);

// Marcamos el ángulo recto
markrightangle(C, A, B, 4mm, gray);

// La mediana
draw(B -- M);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot("A", A, SW, 3bp+black);
dot("B", B, N, 3bp+black);
dot("C", C, SE, 3bp+black);
dot("M", M, S, 3bp+black);
