//---------------------------------------------------------------
// Fichero:  enunciado2.asy
// Objetivo: Representar el enunciado 2
// Fecha:    J.29.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,4), B=(9,4), C=(3,2);

// El triangulo
draw(A -- B -- C -- cycle);

// Los ángulos
pen FormArc=0.5bp+blue;
markangle("$44^\circ$", radius=6mm, C, A, B, FormArc);
markangle("$15^\circ$", radius=12mm, A, B, C, FormArc);
markangle("$\alpha$", radius=3mm, B, C, A, FormArc);

