//---------------------------------------------------------------
// Fichero:  mediana.asy
// Objetivo: Representar una mediana
// Fecha:    D.2.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(3.5,0.5), C=(1,2);

// El punto medio
pair M=(B+C)/2;

// La mediana
draw(A -- M, 2bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, N, 3bp+black);
dot("M", M, NE, 3bp+black);
