//---------------------------------------------------------------
// Fichero:  mediana2.asy
// Objetivo: Representar la mediana 2
// Fecha:    D.2.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(3,1.4);

// El punto medio
pair M=(A+C)/2;

// La mediana
draw(B -- M, 2bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);
dot(M, 3bp+black);
