//---------------------------------------------------------------
// Fichero:  mediatriz2.asy
// Objetivo: Representar una mediatriz
// Fecha:    X.5.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,1), C=(4,4);

// Punto medio
pair M=(A+C)/2;

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// La mediatriz
pair M1=M+0.2*Perpendicular(A,C);
pair M2=M-0.4*Perpendicular(A,C);
draw(M1 -- M2, 1bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot(M, 3bp+black);
