//---------------------------------------------------------------
// Fichero:  bisectriz2.asy
// Objetivo: Representar una bisectriz
// Fecha:    D.23.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,1), C=(4,4);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);

// Función que devuelve un vector en la dirección bisectriz
pair Bisectriz(pair P1, pair V, pair P2)
    { return unit(P1-V) + unit(P2-V); }

// La bisectriz
pair VR = Bisectriz(B,A,C);
pair R1 = A + 2.5*VR;
pair R2 = A - 0.2*VR;
draw(R1 -- R2, blue);
