//---------------------------------------------------------------
// Fichero:  isosceles.asy
// Objetivo: Representar un triangulo isósceles y sus coincidencias
// Fecha:    J.29.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(2,5), B=(0,0), C=(4,0);

// El punto medio de BC
pair M=(B+C)/2;

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, W, 3bp+black);
dot("C", C, E, 3bp+black);
dot("M", M, SE, 3bp+black);

// La altura
draw(A -- M, blue);

// La mediatriz
pen Punteado = linetype(new real[] {2,2});
draw(A+N -- M+S, blue+Punteado);
label("$r$", A+N, SE);

// El triangulo
draw(A -- B -- C -- cycle);

// Marcamos el ángulo recto
markrightangle(A, M, B, 2mm, gray);
