//---------------------------------------------------------------
// Fichero:  baricentro.asy
// Objetivo: Representar el baricentro
// Fecha:    X.5.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,1), C=(2,5);

// Los puntos medios
pair MBC=(B+C)/2;
pair MAB=(A+B)/2;
pair MAC=(A+C)/2;

// Las medianas
draw(A -- MBC, 1bp+blue);
draw(B -- MAC, 1bp+blue);
draw(C -- MAB, 1bp+blue);

// Los puntos
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);

// El baricentro
pair G=intersectionpoint(A -- MBC, B -- MAC);
dot(G, 4bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Puntos medios
dot(MAB, 3bp+green);
dot(MAC, 3bp+green);
dot(MBC, 3bp+green);
