//---------------------------------------------------------------
// Fichero:  ortocentro.asy
// Objetivo: Representar el ortocentro
// Fecha:    X.5.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,1), C=(2,5);

// Función que devuelve un vector perpendicular al segmento dado
pair Perpendicular(pair A, pair B)
    { return (A.y - B.y, B.x - A.x); }

// Las proyecciones
pair QBC=intersectionpoint(B -- C, A -- A-2*Perpendicular(B,C));
pair QAB=intersectionpoint(A -- B, C -- C-2*Perpendicular(A,B));
pair QAC=intersectionpoint(A -- C, B -- B+2*Perpendicular(A,C));

// Las alturas
draw(A -- QBC, 1bp+blue);
draw(B -- QAC, 1bp+blue);
draw(C -- QAB, 1bp+blue);

// El ortocentro
pair H=extension(B, QAC, A, QBC);

// Los puntos
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);
dot(H, 4bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Marcamos los ángulos rectos
markrightangle(B, QAB, H, 2mm, gray);
markrightangle(B, QBC, H, 2mm, gray);
markrightangle(A, QAC, H, 2mm, gray);
