//---------------------------------------------------------------
// Fichero:  alternativa.asy
// Objetivo: Representar una resolución alternativa
// Fecha:    J.6.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices de la base
pair A=(0,0), B=(1,0);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Función que devuelve una etiqueta de tamaño determinado
Label Eti(string Texto)
    { return Label(Texto,fontsize(8pt)); }

// Función que devuelve un vector en la dirección bisectriz
pair Bisectriz(pair P1, pair V, pair P2)
    {
    P1 = P1 - V; P2 = P2 - V;
    return 1/length(P1)*P1 + 1/length(P2)*P2;
    }

// El vértice superior
pair P=A+2*PuntoCir(32), Q=B+2*PuntoCir(180-48);
pair C=intersectionpoint(A -- P, B -- Q);

// Las bisectrices
pair P = A+0.5*Bisectriz(B,A,C);
draw(A -- P, 0.5bp+blue);
pair Q = B+0.4*Bisectriz(C,B,A);
draw(B -- Q, 0.5bp+blue);

// Los ángulos
markangle("$16^\circ$", radius=10mm, B, A, P, 0.5bp+blue);
markangle("$24^\circ$", radius=7mm, Q, B, A, 0.5bp+blue);

// El incentro
pair I=intersectionpoint(A -- P, B -- Q);

// Una paralela a la base
pair R1=intersectionpoint(A -- C, I -- I-(1,0));
pair R2=intersectionpoint(B -- C, I -- I+(1,0));
draw(R1 -- R2, 0.5bp+blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot(Eti("A"), A, W, 3bp+black);
dot(Eti("B"), B, E, 3bp+black);
dot(Eti("I"), I, N, 3bp+black);
dot(Eti("P"), P, N, 3bp+black);
dot(Eti("Q"), R2, SW, 3bp+black);

// La incógnita
markangle("$\alpha$", radius=12mm, B, I, P, 1bp+blue);
