//---------------------------------------------------------------
// Fichero:  triangulo.asy
// Objetivo: Representar el triángulo
// Fecha:    J.6.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices de la base
pair A=(0,0), B=(1,0);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// El vértice superior
pair P=A+2*PuntoCir(32), Q=B+2*PuntoCir(180-48);
pair C=intersectionpoint(A -- P, B -- Q);

// Los ángulos
markangle("$32^\circ$", radius=6mm, B, A, C, 0.5bp+black);
markangle("$48^\circ$", radius=4mm, C, B, A, 0.5bp+black);

// El triangulo
draw(A -- B -- C -- cycle);
