//---------------------------------------------------------------
// Fichero:  demostracion1.asy
// Objetivo: Figura 1 de la demostración
// Fecha:    L.10.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los catetos
real b=5, c=2;

// Definición de los vértices del cuadrado grande
pair A=(0,0), B=(b+c,0), C=(b+c,b+c), D=(0,b+c);

// El cuadrado grande
draw(box(A,C));

// Definición de los vértices del cuadrado pequeño
pair E1=(c,0), F=(b+c,c), G=(b,b+c), H=(0,b);

// El cuadrado pequeño
filldraw(E1 -- F -- G -- H -- cycle, lightgray);

// Los nombres
label(Label("T1",fontsize(18pt)), (G+D+H)/3);
label(Label("T2",fontsize(18pt)), (F+C+G)/3);
label(Label("T3",fontsize(18pt)), (E1+B+F)/3);
label(Label("T4",fontsize(18pt)), (A+E1+H)/3);
label(Label("$a^2$",fontsize(32pt)+blue), C/2);
label(Label("$c$",fontsize(18pt)), (A+E1)/2, S);
label(Label("$b$",fontsize(18pt)), (E1+B)/2, S);
label(Label("$c$",fontsize(18pt)), (B+F)/2, E);
label(Label("$b$",fontsize(18pt)), (F+C)/2, E);
label(Label("$c$",fontsize(18pt)), (C+G)/2, N);
label(Label("$b$",fontsize(18pt)), (G+D)/2, N);
label(Label("$c$",fontsize(18pt)), (D+H)/2, W);
label(Label("$b$",fontsize(18pt)), (H+A)/2, W);
label(Label("$a$",fontsize(18pt)), (E1+F)/2, NW);
label(Label("$a$",fontsize(18pt)), (F+G)/2, SW);
label(Label("$a$",fontsize(18pt)), (G+H)/2, SE);
label(Label("$a$",fontsize(18pt)), (H+E1)/2, NE);
