//---------------------------------------------------------------
// Fichero:  demostracion2.asy
// Objetivo: Figura 2 de la demostración
// Fecha:    L.10.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los catetos
real b=5, c=2;

// Definición de los vértices del cuadrado grande
pair A=(0,0), B=(b+c,0), C=(b+c,b+c), D=(0,b+c);

// El cuadrado grande
draw(box(A,C));

// Definición de puntos auxiliares
pair F=(b,0), G=(b+c,c), H=(b,b+c), I=(0,c), J=(b,c);

// Las líneas interiores
filldraw(box(I,H), lightgray);
filldraw(box(F,G), lightgray);
draw(A -- J);
draw(H -- G);

// Los nombres
label(Label("$b^2$",fontsize(32pt)+blue), (I+H)/2);
label(Label("$c^2$",fontsize(32pt)+blue), (F+G)/2);
label(Label("T1",fontsize(18pt)), (H+C+G)/3);
label(Label("T2",fontsize(18pt)), (H+J+G)/3);
label(Label("T3",fontsize(18pt)), (A+I+J)/3);
label(Label("T4",fontsize(18pt)), (A+F+J)/3);
label(Label("$c$",fontsize(18pt)), (F+B)/2, S);
label(Label("$b$",fontsize(18pt)), (A+F)/2, S);
label(Label("$c$",fontsize(18pt)), (B+G)/2, E);
label(Label("$b$",fontsize(18pt)), (G+C)/2, E);
label(Label("$c$",fontsize(18pt)), (H+C)/2, N);
label(Label("$b$",fontsize(18pt)), (H+D)/2, N);
label(Label("$c$",fontsize(18pt)), (I+A)/2, W);
label(Label("$b$",fontsize(18pt)), (I+D)/2, W);
