//---------------------------------------------------------------
// Fichero:  figura.asy
// Objetivo: Mostrar un enunciado
// Fecha:    S.8.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(4,1);

// El ángulo
markrightangle(A, B, C, 2mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
label("1", (B+C)/2, E);
label("4", (A+B)/2, S);
label("$x$", (A+C)/2, N);
