//---------------------------------------------------------------
// Fichero:  ejemplo.asy
// Objetivo: Representar un ejemplo de posición no habitual
// Fecha:    S.1.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(1,2), B=(0,0), C=(3,0);

// El punto proyección
pair Q=intersectionpoint(A -- C, B -- B+(3,3));

// Marcamos el ángulo recto
markrightangle(C, Q, B, 4mm, gray);

// La altura
draw(B -- Q);

// El triangulo
draw(A -- B -- C -- cycle);

// Los datos
label("14", (A+C)/2, NE);
label("11", (B+Q)/2, SE);
