//---------------------------------------------------------------
// Fichero:  rectangulo.asy
// Objetivo: Poner un ejemplo en un triángulo rectángulo
// Fecha:    X.12.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=rotate(50)*(5,0), C=rotate(50)*(0,3);

// El ángulo
markrightangle(B, A, C, 3mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
label("22 cm", (A+B)/2, SE);
label("13 cm", (A+C)/2, SW);
