//---------------------------------------------------------------
// Fichero:  acutangulo.asy
// Objetivo: Representar un triángulo acutángulo con base y altura
// Fecha:    J.13.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Rejilla de ayuda
add(grid(4,3,1bp+gray));

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(1,3);

// El punto proyección
pair Q=(1,0);

// Marcamos el ángulo recto
markrightangle(B, Q, C, 4mm, deepblue);

// La altura
draw(C -- Q);

// El triangulo
draw(A -- B -- C -- cycle);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, N, 3bp+black);
dot("Q", Q, S, 3bp+black);

// Los datos
label("4", (A+B)/2, S);
label("3", (C+Q)/2, E);
