//---------------------------------------------------------------
// Fichero:  acutangulo2.asy
// Objetivo: Paso 2 del triángulo acutángulo
// Fecha:    D.23.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Rejilla de ayuda
add(grid(5,3,1bp+gray));

// Definición de los vértices
pair A=(0,0), B=(4,0), C=(1,3), D=(5,3);

// Los puntos proyección
pair Q=(1,0), R=(5,0);

// La diagonal
draw(C -- B);

// Los triangulos
draw(A -- B -- C -- cycle);
draw(D -- B -- C -- cycle);

// Las líneas auxiliares
pen Punteado = linetype(new real[] {2,2});
draw(C -- Q, Punteado+blue);
draw(B -- R -- D, Punteado+blue);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, S, 3bp+black);
dot("C", C, N, 3bp+black);
dot("D", D, E, 3bp+black);
dot("Q", Q, S, 3bp+black);
dot("R", R, E, 3bp+black);

// La flecha
fill(circle((0.75,1.5),0.1bp), deepgreen);
draw((0.75,1.5) -- (4.75,1.5), deepgreen, Arrow(5bp));
