//---------------------------------------------------------------
// Fichero:  obtusangulo1.asy
// Objetivo: Paso 1 del triángulo obtusángulo
// Fecha:    J.13.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Rejilla de ayuda
add(shift(-2,0)*grid(8,3,1bp+gray));

// Definición de los vértices
pair A=(0,0), B=(6,0), C=(-2,3), D=(4,3);

// La diagonal
draw(C -- B);

// Los triangulos
draw(A -- B -- C -- cycle);
draw(D -- B -- C -- cycle);

// Los puntos
dot("A", A, S, 3bp+black);
dot("B", B, S, 3bp+black);
dot("C", C, N, 3bp+black);
dot("D", D, N, 3bp+black);
