//---------------------------------------------------------------
// Fichero:  catetohipotenusa.asy
// Objetivo: Representar un triángulo con un cateto y la hipotenusa
// Fecha:    D.16.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Valores de los catetos
int b=80, c=39;

// Ángulo de rotación de la figura
int Ang=0;

// Los vértices
pair A=(0,0), B=(b,0), C=(0,c);

// Rotamos dos puntos respecto a A
B = rotate(Ang)*B;
C = rotate(Ang)*C;

// Marcamos el ángulo recto
markrightangle(B, A, C, 4mm, gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los datos
label("89", (B+C)/2, N);
label("80", (A+B)/2, S);
