//---------------------------------------------------------------
// Fichero:  ejemplo.asy
// Objetivo: Ilustrar el ejemplo
// Fecha:    L.7.2.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Caracteres Unicode
include unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Dimensiones de las cajas
real Anchura=3, Altura=1;

// Separación entre cajas
real Separacion=2;

// Separación entre líneas
real SepLineas=1;

// Tamaño y tipo del texto
pen TamTex=Helvetica(series="m",shape="n")+fontsize(3mm);

// La longitud de las flechas horizontales
real LongFlecha=1.5;

// La altura de la flecha vertical
real AltFlecha=0.6;

// Separación de los textos de la flecha
real SepFlecha=0.3;

// Grosor de las líneas
defaultpen(0.7);

// Incógnita
draw(box((0,0),(Anchura,Altura)));
label("$x$",(Anchura/2,Altura/2),TamTex);

// Siguiente punto medio
real Medio=Anchura+Separacion/2;

// Una flecha
draw((Medio-LongFlecha/2,Altura/2) -- (Medio+LongFlecha/2,Altura/2),
      0.25mm+black,Arrow(size=1.5mm));
label("$\times2$",(Medio,0.5*Altura+SepFlecha),TamTex);

// Primer paso intermedio
draw(box((Anchura+Separacion,0),(2*Anchura+Separacion,Altura)));
label("$2x$",(1.5*Anchura+Separacion,Altura/2),TamTex);

// Siguiente punto medio
real Medio=2*Anchura+1.5*Separacion;

// Una flecha
draw((Medio-LongFlecha/2,Altura/2) -- (Medio+LongFlecha/2,Altura/2),
      0.25mm+black,Arrow(size=1.5mm));
label("$+3$",(Medio,0.5*Altura+SepFlecha),TamTex);

// Segundo paso intermedio
draw(box((2*Anchura+2*Separacion,0),(3*Anchura+2*Separacion,Altura)));
label("$2x+3$",(2.5*Anchura+2*Separacion,Altura/2),TamTex);

// Siguiente punto medio
real Medio=3*Anchura+2.5*Separacion;

// Una flecha
draw((Medio-LongFlecha/2,Altura/2) -- (Medio+LongFlecha/2,Altura/2),
      0.25mm+black,Arrow(size=1.5mm));
label("÷$5$",(Medio,0.5*Altura+SepFlecha),TamTex);

// Tercer paso intermedio
draw(box((3*Anchura+3*Separacion,0),(4*Anchura+3*Separacion,Altura)));
label("$\frac{2x+3}{5}$",(3.5*Anchura+3*Separacion,Altura/2),TamTex);

// Siguiente punto medio
real Medio=4*Anchura+3.5*Separacion;

// Una flecha
draw((Medio-LongFlecha/2,Altura/2) -- (Medio+LongFlecha/2,Altura/2),
      0.25mm+black,Arrow(size=1.5mm));
label("$-7$",(Medio,0.5*Altura+SepFlecha),TamTex);

// Expresión final
draw(box((4*Anchura+4*Separacion,0),(5*Anchura+4*Separacion,Altura)));
label("$\frac{2x+3}{5}-7$",(4.5*Anchura+4*Separacion,Altura/2),TamTex);

// Punto medio de la expresión final
real Medio=4.5*Anchura+4*Separacion;

// Flecha hacia abajo
draw((Medio,-SepLineas/2+AltFlecha/2) -- (Medio,-SepLineas/2-AltFlecha/2),
      0.25mm+black,Arrow(size=1.5mm));

// Número final
draw(box((4*Anchura+4*Separacion,-SepLineas),
         (5*Anchura+4*Separacion,-SepLineas-Altura)));
label("$-4$",(4.5*Anchura+4*Separacion,-SepLineas-Altura/2),TamTex);

// Anterior punto medio
real Medio=4*Anchura+3.5*Separacion;

// Una flecha
draw((Medio+LongFlecha/2,-SepLineas-Altura/2) --
     (Medio-LongFlecha/2,-SepLineas-Altura/2),
      0.25mm+black,Arrow(size=1.5mm));
label("$+7$",(Medio,-SepLineas-Altura/2+SepFlecha),TamTex);

// Valor intermedio
draw(box((3*Anchura+3*Separacion,-SepLineas),
        (4*Anchura+3*Separacion,-SepLineas-Altura)));
label("$3$",(3.5*Anchura+3*Separacion,-SepLineas-Altura/2),TamTex);

// Anterior punto medio
real Medio=3*Anchura+2.5*Separacion;

// Una flecha
draw((Medio+LongFlecha/2,-SepLineas-Altura/2) --
     (Medio-LongFlecha/2,-SepLineas-Altura/2),
      0.25mm+black,Arrow(size=1.5mm));
label("$\times5$",(Medio,-SepLineas-Altura/2+SepFlecha),TamTex);

// Valor intermedio
draw(box((2*Anchura+2*Separacion,-SepLineas),
         (3*Anchura+2*Separacion,-SepLineas-Altura)));
label("$15$",(2.5*Anchura+2*Separacion,-SepLineas-Altura/2),TamTex);

// Anterior punto medio
real Medio=2*Anchura+1.5*Separacion;

// Una flecha
draw((Medio+LongFlecha/2,-SepLineas-Altura/2) --
     (Medio-LongFlecha/2,-SepLineas-Altura/2),
      0.25mm+black,Arrow(size=1.5mm));
label("$-3$",(Medio,-SepLineas-Altura/2+SepFlecha),TamTex);

// Valor intermedio
draw(box((Anchura+Separacion,-SepLineas),
        (2*Anchura+Separacion,-SepLineas-Altura)));
label("$12$",(1.5*Anchura+Separacion,-SepLineas-Altura/2),TamTex);

// Anterior punto medio
real Medio=Anchura+Separacion/2;

// Una flecha
draw((Medio+LongFlecha/2,-SepLineas-Altura/2) --
     (Medio-LongFlecha/2,-SepLineas-Altura/2),
      0.25mm+black,Arrow(size=1.5mm));
label("÷$2$",(Medio,-SepLineas-Altura/2+SepFlecha),TamTex);

// Solución
draw(box((0,-SepLineas),(Anchura,-SepLineas-Altura)));
label("$6$",(Anchura/2,-SepLineas-Altura/2),TamTex);
