//---------------------------------------------------------------
// Fichero:  ropa.asy
// Objetivo: Ilustrar cómo vestirse y desvestirse
// Fecha:    S.22.1.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Dimensiones de las cajas
real Anchura=6, Altura=1.8;

// Separación entre cajas
real Separacion=1;

// Tamaño y tipo del texto
pen TamTex=Helvetica(series="m",shape="n")+fontsize(4mm);

// La longitud de las flechas horizontales
real LongFlecha=4*Anchura+3.5*Separacion;

// Separación de los textos de la flecha
real SepFlecha=0.8;

// Grosor de las líneas
defaultpen(0.7);

// Casa
draw(box((0,-0.8*Altura),(Anchura,1.8*Altura)));
label("Casa",(Anchura/2,Altura/2),TamTex);

// Camiseta
draw(box((Anchura+Separacion,0),(2*Anchura+Separacion,Altura)));
label("Camiseta",(1.5*Anchura+Separacion,Altura/2),TamTex);

// Camisa
draw(box((2*Anchura+2*Separacion,0),(3*Anchura+2*Separacion,Altura)));
label("Camisa",(2.5*Anchura+2*Separacion,Altura/2),TamTex);

// Jersey
draw(box((3*Anchura+3*Separacion,0),(4*Anchura+3*Separacion,Altura)));
label("Jersey",(3.5*Anchura+3*Separacion,Altura/2),TamTex);

// Abrigo
draw(box((4*Anchura+4*Separacion,0),(5*Anchura+4*Separacion,Altura)));
label("Abrigo",(4.5*Anchura+4*Separacion,Altura/2),TamTex);

// Calle
draw(box((5*Anchura+5*Separacion,-0.8*Altura),
         (6*Anchura+5*Separacion,1.8*Altura)));
label("Calle",(5.5*Anchura+5*Separacion,Altura/2),TamTex);

// Punto medio
real Medio=3*Anchura+2.5*Separacion;

// La flecha de vestirse
draw((Medio-LongFlecha/2,1.2*Altura) -- (Medio+LongFlecha/2,1.2*Altura),
      0.25mm+blue,Arrow(size=1.5mm));
label("Vestirse",(Medio,1.2*Altura+SepFlecha),TamTex);

// La flecha de desvestirse
draw((Medio+LongFlecha/2,-0.4) -- (Medio-LongFlecha/2,-0.4),
      0.25mm+blue,Arrow(size=1.5mm));
label("Desvestirse",(Medio,-0.4-SepFlecha),TamTex);
