//---------------------------------------------------------------
// Fichero:  paso4.asy
// Objetivo: Representar el paso 4
// Fecha:    D.9.1.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.9cm);

// Grosor de las líneas
defaultpen(1);

// Los coeficientes de los factores
int Factor1[] = {-3, 7, -1, -5, 2};
int Factor2[] = {4, 1, 6, -2, 3};

// Los grados de los factores
int G1 = Factor1.length;
int G2 = Factor2.length;

// La separación entre dos cuadrados
real Sep=sqrt(2);

// Función que devuelve un punto del plano según los grados
pair Punto(int i, int j)
    {
    real X, Y;
    X=4-(i+j)/2;
    Y=2-(i-j)/2;
    return (Sep*X,Sep*Y);
    }

// Función que devuelve el texto de una potencia dado el grado
string Pot(int g)
    {
    string Respuesta;
    if ( g==0 )  { Respuesta = '1'; }
    if ( g==1 )  { Respuesta = 'x'; }
    if ( g>1 )   { Respuesta = 'x$^'+string(g)+'$'; }
    return (Respuesta);
    }

// Formato de los textos
pen ForGen=Helvetica(series="m",shape="n")+fontsize(3mm);
pen ForPot=Helvetica(series="m",shape="n")+fontsize(3mm)+blue;
pen ForSol=Helvetica(series="m",shape="n")+fontsize(2.5mm);

// Los nombres de los polinomios
label('A(x)', (-1.3,7.3), ForGen);
label('B(x)', (6.7,7.3), ForGen);

// El cuadrado básico
path Cuadrado = rotate(45)*box((0,0),(1,1));

// La cuadrícula con los productos
for ( int i=0 ; i<G1 ; ++i )
    {
    for ( int j=0 ; j<G2 ; ++j )
        {
        pair Pos=Punto(i,j);
        draw(shift(Pos)*Cuadrado,1bp+gray);
        label(string(Factor1[i]*Factor2[j]),Pos+(0,Sep/2),ForGen);
        }
    }

// El primer factor
for ( int i=0 ; i<G1 ; ++i )
    {
    // La potencia
    pair Pos=Punto(i,G1+1);
    draw(shift(Pos)*Cuadrado);
    label(Pot(i),Pos+(0,Sep/2),ForPot);

    // El coeficiente
    pair Pos=Punto(i,G1);
    draw(shift(Pos)*Cuadrado);
    label(string(Factor1[i]),Pos+(0,Sep/2),ForGen);
    }

// El segundo factor
for ( int j=0 ; j<G2 ; ++j )
    {
    // La potencia
    pair Pos=Punto(-2,j);
    draw(shift(Pos)*Cuadrado);
    label(Pot(j),Pos+(0,Sep/2),ForPot);

    // El coeficiente
    pair Pos=Punto(-1,j);
    draw(shift(Pos)*Cuadrado);
    label(string(Factor2[j]),Pos+(0,Sep/2),ForGen);
    }

// El producto de los polinomios
int TamPro = G1+G2-1;
int Producto[] = array(TamPro, 0);
for ( int i=0 ; i<G1 ; ++i )
    {
    for ( int j=0 ; j<G2 ; ++j )
        { Producto[i+j] += Factor1[i]*Factor2[j]; }
    }

// La cuadrícula con las sumas
for ( int i=0 ; i<TamPro ; ++i )
    {
    real Anchura = 5*Sep/9;

    // Los coeficientes
    draw(box((-0.75+Anchura*i,-0.5),(-0.75+Anchura*(i+1),-1.5)));
    label(string(Producto[TamPro-i-1]),(-0.75+Anchura*(i+0.5),-1),ForSol);

    // Las potencias
    draw(box((-0.75+Anchura*i,-1.5),(-0.75+Anchura*(i+1),-2.5)));
    label(Pot(TamPro-i-1),(-0.75+Anchura*(i+0.5),-2),ForPot);

    // Las flechas
    real Altura = 0;
    if ( i!=4 )
        {
        if ( abs(4-i)== 0 )  { Altura = 0; }
        if ( abs(4-i)== 1 )  { Altura = 0.7; }
        if ( abs(4-i)== 2 )  { Altura = 1.4; }
        if ( abs(4-i)== 3 )  { Altura = 2.15; }
        if ( abs(4-i)== 4 )  { Altura = 3; }
        draw((-0.36+Anchura*i,Altura) -- (-0.36+Anchura*i,-0.25),
             1pt+heavygreen,Arrow(HookHead,size=1mm));
        }
    }
