//---------------------------------------------------------------
// Fichero:  visualizacion.asy
// Objetivo: Visualizar el cuadrado de una diferencia
// Fecha:    J.13.1.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Los valores
real a=4.8, b=2.8;

// Los rectángulos
filldraw(box((0,a),(a+b,a+b)),palegray);
filldraw(box((a,0),(a+b,a+b)),palegray);
filldraw(box((a,a),(a+b,a+b)),mediumgray);
draw(box((0,0),(a+b,a+b)));
draw(box((0,0),(a,a)));
draw(box((a,a),(a+b,a+b)));

// La separación entre las flechas y el objeto
real Separacion = 0.5;

// Las flechas que señalan los tamaños
draw((-Separacion,0) -- (-Separacion,a+b),
     blue, Arrows(HookHead,3bp), Bars(2mm));
draw((0,-Separacion) -- (a+b,-Separacion),
     blue, Arrows(HookHead,3bp), Bars(2mm));
draw((a+b+Separacion,0) -- (a+b+Separacion,a),
     blue, Arrows(HookHead,3bp), Bars(2mm));
draw((a+b+Separacion,a) -- (a+b+Separacion,a+b),
     blue, Arrows(HookHead,3bp), Bars(2mm));
draw((0,a+b+Separacion) -- (a,a+b+Separacion),
     blue, Arrows(HookHead,3bp), Bars(2mm));
draw((a,a+b+Separacion) -- (a+b,a+b+Separacion),
     blue, Arrows(HookHead,3bp), Bars(2mm));

// Los textos
label("$a$", (-2.5*Separacion,0.5*(a+b)), fontsize(12pt));
label("$a$", (0.5*(a+b),-2.5*Separacion), fontsize(12pt));
label("$a-b$", (a+b+5*Separacion,0.5*a), fontsize(12pt));
label("$b$", (a+b+2.5*Separacion,a+0.5*b), fontsize(12pt));
label("$a-b$", (0.5*a,a+b+2.5*Separacion), fontsize(12pt));
label("$b$", (a+0.5*b,a+b+2.5*Separacion), fontsize(12pt));
label("$(a-b)^2$", (0.5*a,0.5*a), fontsize(12pt));
label("$b^2$", (a+0.5*b,a+0.5*b), fontsize(12pt));
label("$ab$", (a+0.5*b,0.5*a), fontsize(12pt));
label("$ab$", (0.5*a,a+0.5*b), fontsize(12pt));
