//---------------------------------------------------------------
// Fichero:  visualizacion.asy
// Objetivo: Visualizar suma por diferencia
// Fecha:    J.13.1.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Grosor de las líneas
defaultpen(1);

// Los valores
real a=4.8, b=1.8;

// Tamaño del texto
pen TamTex = fontsize(12pt);

// Color
pen Color = lightgray;

// La separación entre las flechas y el objeto
real Sep1 = 0.2;

// La separación entre las flechas y los textos
real Sep2 = 0.45;

// La separación entre las dos partes
real Sep3 = a+2.5;

// Parte izquierda

// Los rectángulos
filldraw(box((0,0),(a,a-b)),Color);
filldraw(box((0,a-b),(a-b,a)),Color);
draw(box((0,0),(a,a)));

// Las flechas que señalan los tamaños
draw((-Sep1,0) -- (-Sep1,a), blue, Arrows(HookHead,3bp), Bars(2mm));
draw((0,-Sep1) -- (a,-Sep1), blue, Arrows(HookHead,3bp), Bars(2mm));
draw((0,a+Sep1) -- (a-b,a+Sep1), blue, Arrows(HookHead,3bp), Bars(2mm));
draw((a+Sep1,a-b) -- (a+Sep1,a), blue, Arrows(HookHead,3bp), Bars(2mm));
draw((a-b,a+Sep1) -- (a,a+Sep1), blue, Arrows(HookHead,3bp), Bars(2mm));
draw((a+Sep1,0) -- (a+Sep1,a-b), blue, Arrows(HookHead,3bp), Bars(2mm));

// Los textos
label("$a$", (-Sep2,0.5*a), TamTex);
label("$a$", (0.5*a,-Sep2), TamTex);
label("$b$", (a-b+0.5*b,a+Sep2), TamTex);
label("$b$", (a+Sep2,a-b+0.5*b), TamTex);
label("$a-b$", (0.5*(a-b),a+Sep2), TamTex);
label("$a-b$", (a+Sep2+Sep2,0.5*(a-b)), TamTex);

// Parte derecha

// Los rectángulos
filldraw(box((Sep3,0),(Sep3+a,a-b)),Color);
filldraw(box((Sep3+a,0),(Sep3+a+b,a-b)),Color);
draw(box((Sep3,0),(Sep3+a+b,a)));

// Las flechas que señalan los tamaños
draw((Sep3-Sep1,0) -- (Sep3-Sep1,a), blue, Arrows(HookHead,3bp), Bars(2mm));
draw((Sep3,a+Sep1) -- (Sep3+a,a+Sep1), blue, Arrows(HookHead,3bp), Bars(2mm));
draw((Sep3+a,a+Sep1) -- (Sep3+a+b,a+Sep1), blue, Arrows(HookHead,3bp), Bars(2mm));
draw((Sep3+a+b+Sep1,a-b) -- (Sep3+a+b+Sep1,a), blue, Arrows(HookHead,3bp), Bars(2mm));
draw((Sep3,-Sep1) -- (Sep3+a+b,-Sep1), blue, Arrows(HookHead,3bp), Bars(2mm));
draw((Sep3+a+b+Sep1,0) -- (Sep3+a+b+Sep1,a-b), blue, Arrows(HookHead,3bp), Bars(2mm));

// Los textos
label("$a$", (Sep3-Sep2,0.5*a), TamTex);
label("$a$", (Sep3+0.5*a,a+Sep2), TamTex);
label("$b$", (Sep3+a+0.5*b,a+Sep2), TamTex);
label("$b$", (Sep3+a+b+Sep2,a-b+0.5*b), TamTex);
label("$a+b$", (Sep3+0.5*(a+b),-Sep2), TamTex);
label("$a-b$", (Sep3+a+b+Sep2+Sep2,0.5*(a-b)), TamTex);
