//---------------------------------------------------------------
// Fichero:  resolucion2.asy
// Objetivo: Representar la resolución 2
// Fecha:    D.12.9.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Para los caracteres no ASCII
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Los valores fundamentales
real Altura=3, Anchura=4, DivVer=1, DivHor=0.62;

// El rectángulo que marca la fracción principal
fill(box((0,0),(DivVer,Altura)), mediumgray);

// El rectángulo que marca la fracción secundaria
fill(box((DivVer,DivHor),(Anchura,Altura)), palered);

// El rectángulo que marca el total
draw(box((0,0),(Anchura,Altura)));

// La línea vertical
draw((DivVer,0) -- (DivVer,Altura));

// La línea horizontal
pen Punteado = linetype(new real[] {2,2});
draw((DivVer,DivHor) -- (Anchura,DivHor), Punteado);

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan los datos
draw((0,Altura+Separacion) -- (Anchura,Altura+Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((0,-Separacion) -- (DivVer,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((Anchura+Separacion,DivHor) -- (Anchura+Separacion,Altura),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Los textos
label("¿Total?", (Anchura/2,Altura+2*Separacion), fontsize(8pt));
label(rotate(90)*"Mala calidad", (DivVer/2,Altura/2), fontsize(8pt));
label("Venta", ((DivVer+Anchura)/2,(DivHor+Altura)/2), fontsize(8pt));
label("$\frac{1}{4}$", (DivVer/2,-2.5*Separacion), fontsize(8pt));
label("$\frac{31}{39}$", (Anchura+2*Separacion,(DivHor+Altura)/2), fontsize(8pt));
label("208", ((DivVer+Anchura)/2,DivHor/2), fontsize(8pt));
