#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  reparto.py
# Objetivo: Hace un reparto inversamente proporcional
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    M.9.11.2021
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos el número que hay que repartir
Numero = float(sys.argv[1])

# Leemos las partes en que hay que repartir
Partes = map(float,sys.argv[2:])

# Calculamos los inversos
Partes = map(lambda x: 1/x, Partes)

# La suma de todas las partes
Suma = sum(Partes)

# La cantidad que corresponde por cada unidad
Unidad = Numero / Suma

# Imprimimos el reparto
for Parte in Partes:
    print Parte*Unidad,
