//---------------------------------------------------------------
// Fichero:  finalinicial.asy
// Objetivo: Paso de la cantidad final a la inicial
// Fecha:    D.12.12.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Caracteres Unicode
include unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de las cajas
real Anchura=7, Altura=1;

// Separación entre cajas
real Separacion=10;

// Tamaño y tipo del texto
pen TamTex=Helvetica(series="m",shape="n")+fontsize(3mm);

// Punto medio de la figura
real Medio=Anchura+Separacion/2;

// La longitud de la flecha
real LongFlecha=8.5;

// Separación de los textos de la flecha
real SepFlecha=0.3;

// Grosor de las líneas
defaultpen(1);

// Cantidad inicial
draw(box((0,0),(Anchura,Altura)));
label("Cantidad inicial",(Anchura/2,Altura/2),TamTex);

// Una flecha
draw((Medio+LongFlecha/2,Altura/2) -- (Medio-LongFlecha/2,Altura/2),
      0.25mm+black,Arrow(size=2.5mm));
label("Variación porcentual",(Medio,Altura+SepFlecha),TamTex);
label("$\div$ Índice de variación",(Medio,-SepFlecha),TamTex);

// Cantidad final
draw(box((Anchura+Separacion,0),(2*Anchura+Separacion,Altura)));
label("Cantidad final",(1.5*Anchura+Separacion,Altura/2),TamTex);
